#pragma once

#include "exceptions.h"
#include "singletons.h"
#include "Areas.h"
#include "LinksManager.h"

class CAreasManager : public CSingleton
{
public:
	virtual ~CAreasManager();

	virtual void addArea(PArea newArea) { areas.push_back( newArea ); }
	virtual void addGroup(PAreaGroup newGroup) { groups.push_back( newGroup ); }
 
	PAreaGroup getGroup(const tstring& groupName);
	PAreaGroup getGroup(int index);

	int getGroupsCount() const { return groups.size(); }

	PArea getArea(const tstring& areaName);
	PArea getArea(int index) { return areas[index]; }

	int getAreasCount() const { return areas.size(); }

	PArea autoCreate(const tstring& areaName, PLink creator)
		throw(CLogicException);

	static CAreasManager* getInstance() throw(CBadConfigException) {
		static CAreasManager	areasManager;

		if (!areasManager.loaded) {
			areasManager.load();
		}

		return &areasManager;
	}

	void affectAreas() { areasChanged = true; }


	// singleton implementations


	virtual void destroy() {
		if (areasChanged) {
			saveAreas();
		}
	}

	virtual CSingletonVector getDependencies() {
		CSingletonVector	dependencies;
		dependencies.push_back( CLinksManager::getInstance() );

		return dependencies;
	}

	// group iterator

	class CGroupIterator {
	public:
		CGroupIterator();
		CGroupIterator(CAreasManager* aManager, int anIndex);
		CGroupIterator(const CGroupIterator& instance);
		virtual ~CGroupIterator() {}

		CGroupIterator& operator =(const CGroupIterator& instance);

		bool operator ==(const CGroupIterator& instance);
		bool operator !=(const CGroupIterator& instance);

		CGroupIterator& operator ++();
		PAreaGroup operator *();

	protected:
		CAreasManager*	manager;
		int				index;
	};

	CGroupIterator	groupBegin();
	CGroupIterator	groupEnd();

	// area iterator

	class CAreaIterator {
	public:
		CAreaIterator();
		CAreaIterator(CAreasManager* aManager, PAreaGroup aGroup, int anAreaIndex);
		CAreaIterator(const CAreaIterator& instance);
		virtual ~CAreaIterator() {}

		CAreaIterator& operator =(const CAreaIterator& instance);

		bool operator ==(const CAreaIterator& instance);
		bool operator !=(const CAreaIterator& instance);

		CAreaIterator& operator ++();
		PArea operator *();

	protected:
		CAreasManager*	manager;
		PAreaGroup		group;
		int				areaIndex;
	};

	CAreaIterator areaBegin();
	CAreaIterator areaEnd();

	CAreaIterator areaBegin(PAreaGroup group);
	CAreaIterator areaEnd(PAreaGroup group);

protected:
	CAreasManager();
	// virtual bool parseAreaAccess(LPCTSTR s, PArea area, tstring& group);

	vector<PAreaGroup>	groups;
	vector<PArea>		areas;

	bool				areasChanged;

	bool	loaded;
	void load() throw(CBadConfigException);
	void saveAreas();
};
